Unit KBDriver ;

Interface

Type
	VectorType	= (Stay,N,NE,East,SE,S,SW,W,NW) ;
Var
	KBDHit		: Boolean ;
	KBDExt		: Boolean ;
	KBDCode		: byte ;
	Vector		: VectorType ;

Procedure KBDSet (Setup : Boolean) ;

		{	KBDSet(true)	- setup keyboard driver
			KBDSet(false)	- return to system driver

			KBDHit		set true after interrupt (key press
						or release
			KBDExt		set true if additional keys on 101
						key keyboard pressed
			KBDCode		key number (Scan code)				}

Implementation

Uses Dos ;
Const
	Copyrt = 'Copyright (C) 1989 by Eugene Crosser, Moscow' ;
Var
	OldVec		: pointer ;
	ExtCode		: Boolean ;
	LastKey		: VectorType ;
	PressSet	: array [VectorType] of Boolean ;
{$F+}
Procedure KeyISR (Flags,CS,IP,AX,BX,CX,DX,SI,DI,DS,ES,BP : word) ;
			interrupt ;
	Var
		St1,St2		: byte ;
		Port60		: byte ;
		Key		: VectorType ;
		NumKey		: integer ;
	Begin
		Port60 := Port[$60] ;
		St1 := Port[$61] ;
		St2 := St1 or $80 ;
		Port[$61] := St2 ;
		Port[$61] := St1 ;
		if (Port60 = 224) or (Port60 = 225) then ExtCode := true
		else if ((Port60 <> 42) and (Port60 <> 170))
				or (not ExtCode) then begin
			KBDCode := Port60 ;
			if ExtCode then KBDExt := true else KBDExt := false ;
			{ that's nonsense, but KBDExt := ExtCode doesn't work }
			KBDHit := true ;
			ExtCode := false ;
			case Port60 of
			71  : begin PressSet[NW] := true  ; LastKey := NW end ;
			199 : begin PressSet[NW] := false end ;
			72  : begin PressSet[N ] := true  ; LastKey := N  end ;
			200 : begin PressSet[N ] := false end ;
			73  : begin PressSet[NE] := true  ; LastKey := NE end ;
			201 : begin PressSet[NE] := false end ;
			75  : begin PressSet[W ] := true  ; LastKey := W  end ;
			203 : begin PressSet[W ] := false end ;
			77  : begin PressSet[East] := true  ; LastKey := East end ;
			205 : begin PressSet[East] := false end ;
			79  : begin PressSet[SW] := true  ; LastKey := SW end ;
			207 : begin PressSet[SW] := false end ;
			80  : begin PressSet[S ] := true  ; LastKey := S  end ;
			208 : begin PressSet[S ] := false end ;
			81  : begin PressSet[SE] := true  ; LastKey := SE end ;
			209 : begin PressSet[SE] := false end ;
			else  LastKey := Stay
			end { of case } ;
			NumKey := 0 ;
			for Key := Stay to NW do if PressSet[Key] then
				NumKey := NumKey + 1 ;
			case NumKey of
			0 : Vector := Stay ;
			1 : for Key := Stay to NW do if PressSet[Key] then
				Vector := Key ;
			else Vector := LastKey
			end { of case }
		end ;
		Port[$20] := $20 ;
	end ; { of procedure KeyISR }

Procedure KBDSet ;
Begin
	if setup then begin
		for LastKey := Stay to NW do PressSet[LastKey] := false ;
		LastKey := Stay ;
		GetIntVec($09,OldVec) ;
		SetIntVec($09,Addr(KeyISR))
	end else
		SetIntVec($09,OldVec)
end ; { of procedure KBDSet }
{$F-}

end .