Unit RMusic ;

Interface

Type
	NoteType	=	record
						Octave		,
						Note		,
						Stacatto	: byte ;
						Duration	: integer
					end ;

Const

	{ Note constants }

	C		=  1 ;
	Cis		=  2 ;
	Des		=  2 ;
	D		=  3 ;
	Dis		=  4 ;
	Ees		=  4 ;
	E		=  5 ;
	F		=  6 ;
	Fis		=  7 ;
	Ges		=  7 ;
	G		=  8 ;
	Gis		=  9 ;
	Aes		=  9 ;
	A		= 10 ;
	Bes		= 10 ;
	Ais		= 11 ;
	B		= 11 ;
	Hes		= 11 ;
	Bis		= 12 ;
	H		= 12 ;

	R		= 13 ;
	Pause	= 13 ;

	{ Special end of data constants }

	RMHalt		: NoteType =
		(Octave:1;note:1;stacatto:0;duration:-1) ;
	RMRestart	: NoteType =
		(Octave:1;note:1;stacatto:0;duration:0) ;

	{ Setup constants }

	RMSetup	= 0 ;
	RMStart	= 1 ;
	RMStop	= 2 ;
	RMClose	= 3 ;

Var
	RMExpired	: Boolean ;

Procedure RMSet (	Action	: byte ;
					Address	: pointer ) ;

		{	Procedure RMSet is used for asyncronous music
			setup, start, terminate and close.

			There are following calls :
			RMSet(RMSetup,nil)		: setup environment ;
			RMSet(RMStart,Melody)	: start playing ;
			RMSet(RMStop,nil)		: stop playing ;
			RMSet(RMClose,nil)		: delete environment

			Melody should have following structure :
			Melody : array [0..?] of record
						Octave		: byte ;
						Note		: byte ;
						Stacatto	: byte ;
						Duration	: integer
					end ;

			Zero duration forces RMusic to play from the
			beginning; if duration < 0 then playing stops
			forever.

			In addition, RMusic, when set up, turns global
			Boolean variable RMExpired true every timer
			interrupt (17-18 times per second).
																}
Implementation

Uses CRT,Dos ;
Type
	NoteArrayType =	array [0..0] of NoteType ;
Const
	Copyrt	= 'Copyright (C) 1989 by Eugene Crosser, Moscow' ;
Var
	RMdebug		: Boolean ;
	RMplay		: Boolean ;
	RMtime		: integer ;
	RMbegin		: ^NoteArrayType ;
	RMcurrent	: integer ;
	RMoldvec	: pointer ;
{$F+}
Procedure Tick (Flags,CS,IP,AX,BX,CX,DX,SI,DI,DS,ES,BP : word) ;
	interrupt ;
	Const
		gamma : array [1..13] of integer = (
			262 , 277 , 294 , 311 , 330 , 349 ,
			370 , 392 , 415 , 440 , 466 , 494 , 0 ) ;
	Var
		x,y				: integer ;
		freq,i,factor	: integer ;
	Begin
		RMExpired := true ;
		if RMplay then begin
			if RMtime <> 0 then RMtime := RMtime - 1 else begin
				RMcurrent := RMcurrent + 1 ;
{$R-}
				with RMbegin^[RMcurrent] do begin
{$R+}
					if duration < 0 then RMplay := false ;
					if duration = 0 then begin
						RMcurrent := -1 ;
						RMtime := 0
					end else begin
						factor := 1 ;
						for i := 1 to octave do factor := factor + factor ;
						freq := factor * gamma[note] div 16 ;
						if RMdebug then begin
							x := WhereX ;
							y := WhereY ;
							GoToXY(60,1) ;
							writeln(octave:4,note:4,stacatto:4,duration:6) ;
							GoToXY(60,2) ;
							writeln(factor:6,gamma[note]:6,freq:6) ;
							GoToXY(x,y)
						end ;
						if stacatto <> 0 then begin
							NoSound ;
							Delay(stacatto*10)
						end ;
						if (freq <> 0) and RMplay then
							Sound(freq) else NoSound ;
						RMtime := duration ;
					end
				end
			end
		end
	end ; { of procedure Tick }

Procedure RMSet ;
	Begin
		case Action of
		RMSetup : begin
			RMExpired := false ;
			RMdebug := Address <> nil ;
			RMplay := false ;
			NoSound ;
			RMtime := 0 ;
			RMbegin := nil ;
			RMcurrent := 0 ;
			GetIntVec ($1C,RMoldvec) ;
			SetIntVec ($1C,Addr(Tick))
		end ;
		RMStart : begin
			RMbegin := Address ;
			RMCurrent := -1 ;
			RMTime := 0 ;
			RMplay := true
		end ;
		RMStop : begin
			RMplay := false ;
			NoSound ;
			RMtime := 0 ;
			RMbegin := nil ;
			RMcurrent := 0 ;
		end ;
		RMClose : begin
			SetIntVec($1C,RMoldvec) ;
			Nosound
		end
		end { of case }
	end ; { of procedure RMSet }
end .
