Procedure SetEnv ;
Var
	GraphError		: integer ;
Begin
	DetectGraph(GraphDriver,GraphMode) ;
	if (ParamStr(1) = '/c') or (ParamStr(1) = '/C') then
		GraphDriver := CGA ;
	if GraphDriver < 3 then GraphMode := CGAC1 ;
	InitGraph(GraphDriver,GraphMode,'') ;
	GraphError := GraphResult ;
	if GraphError <> 0 then begin
		writeln('Graphics initialization error : ',
			GraphErrorMsg(GraphError)) ;
		halt(1)
	end ;
	RMSet(RMSetup,nil) ;
	if GraphDriver < 3 then begin	{ CGA }
		SpeedHero := 2 ;
		InitSpeedEnemy := 1 ;
		SizeHero.X := 8 ;
		SizeHero.Y := 4 ;
		SizeEnemy.X := 8 ;
		SizeEnemy.Y := 4 ;
		SizeMine.X := 2 ;
		SizeMine.Y := 2 ;
		SizeFlash := 1 ;
		BackColor := 1 ;
		MainColor := 0 ;
		Color1 := 3 ;
		Color2 := 2
	end else begin			{ EGA }
		SpeedHero := 4 ;
		InitSpeedEnemy := 2 ;
		SizeHero.X := 14 ;
		SizeHero.Y := 6 ;
		SizeEnemy.X := 14 ;
		SizeEnemy.Y := 6 ;
		SizeMine.X := 5 ;
		SizeMine.Y := 4 ;
		SizeFlash := 1 ;
		BackColor := Cyan ;
		MainColor := Black ;
		Color1 := LightBlue ;
		Color2 := LightRed
	end ;
	SoundOn := true ;
	RmaxX := GetMaxX ;
	RmaxY := GetMaxY ;
	BorderY := RmaxY div 10 ;
	MaxX := RmaxX ;
	MaxY := RmaxY-BorderY ;
	Chtime := 5 ;
	GetMem(ImgHero1,ImageSize(MaxX div 2 - SizeHero.X,
				MaxY div 2 - SizeHero.Y,
				MaxX div 2 + SizeHero.X,
				MaxY div 2 + SizeHero.Y)) ;
	GetMem(ImgHero2,ImageSize(MaxX div 2 - SizeHero.X,
				MaxY div 2 - SizeHero.Y,
				MaxX div 2 + SizeHero.X,
				MaxY div 2 + SizeHero.Y)) ;
	GetMem(ImgEnemy1,ImageSize(MaxX div 2 - SizeEnemy.X,
				MaxY div 2 - SizeEnemy.Y,
				MaxX div 2 + SizeEnemy.X,
				MaxY div 2 + SizeEnemy.Y)) ;
	GetMem(ImgEnemy2,ImageSize(MaxX div 2 - SizeEnemy.X,
				MaxY div 2 - SizeEnemy.Y,
				MaxX div 2 + SizeEnemy.X,
				MaxY div 2 + SizeEnemy.Y)) ;
	GetMem(ClearEnemy,ImageSize(MaxX div 2 - SizeEnemy.X,
				MaxY div 2 - SizeEnemy.Y,
				MaxX div 2 + SizeEnemy.X,
				MaxY div 2 + SizeEnemy.Y)) ;
	GetMem(ImgMine,ImageSize(MaxX div 2 - SizeMine.X,
				MaxY div 2 - SizeMine.Y,
				MaxX div 2 + SizeMine.X,
				MaxY div 2 + SizeMine.Y)) ;
	GetMem(ClearMine,ImageSize(MaxX div 2 - SizeMine.X,
				MaxY div 2 - SizeMine.Y,
				MaxX div 2 + SizeMine.X,
				MaxY div 2 + SizeMine.Y)) ;
	ImgHero := ImgHero1 ;
	ImgEnemy := ImgEnemy1 ;
	GetMem(RestHeroX,ImageSize(0,0,
				SpeedHero,
				SizeHero.Y*2)) ;
	GetMem(RestHeroY,ImageSize(0,0,
				SizeHero.X*2,
				SpeedHero)) ;
	GetMem(RestEnemyX,ImageSize(0,0,
				SpeedHero,
				SizeEnemy.Y*2)) ;
	GetMem(RestEnemyY,ImageSize(0,0,
				SizeEnemy.X*2,
				SpeedHero)) ;
end ; { of procedure SetEnv }