#ifndef LINT
static char *rcsid="$Id: clamav.c 238 2004-12-14 01:06:52Z crosser $";
#endif

/*
	$Log: clamav.c,v $
	Revision 1.13  2004/12/14 00:25:34  crosser
	make configuration: options, limits etc.
	
	Revision 1.12  2004/12/13 19:59:32  crosser
	check IO result for tmp file
	dirty kludge to PATH to make "make distcheck" work
	version 1.01
	
	Revision 1.11  2004/12/13 15:10:41  crosser
	implemented basics for scanning temp files
	
	Revision 1.10  2004/01/29 18:00:59  crosser
	typo in Id
	
	Revision 1.9  2004/01/29 17:32:47  crosser
	make info message, bump version
	
	Revision 1.8  2003/09/15 13:41:54  crosser
	report by setting variable
	
	Revision 1.7  2003/09/14 22:11:51  crosser
	removed dprint
	
	Revision 1.6  2003/09/10 21:24:24  crosser
	cosmetic
	
	Revision 1.5  2003/09/09 20:04:29  crosser
	stage name changed from "body" to "content"
	
	Revision 1.4  2003/09/08 13:01:57  crosser
	change ZMSCAN_REJECT to ZMSCAN_STOP
	
	Revision 1.3  2003/09/06 21:47:56  crosser
	don't scan text type
	
	Revision 1.2  2003/09/06 21:26:52  crosser
	Cool!  scanning works!
	
	Revision 1.1.1.1  2003/09/06 20:50:37  crosser
	Importe source
	
*/
                                                                                
/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#ifdef HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif
#ifdef STDC_HEADERS
# include <stdio.h>
# include <string.h>
#endif
#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif

#include <zmscanner.h>
#include <clamav.h>

#include "clamav_config.h"
#include "report.h"

#define CONFFILE "clamav.conf"

#define min(x,y) ((x<y)?x:y)

static int
clamav_setup(void **priv)
{
	clamav_cfg_t *cfg;
	int rc;
	int virnum=0;
	char fbuf[128];

	DPRINT(("clamav_setup starting\n"));

	snprintf(fbuf,sizeof(fbuf),"%s/%s",modconfdir(),CONFFILE);
	cfg=clamav_config(fbuf);

	rc=cl_loaddbdir(cfg->dbdir?cfg->dbdir:cl_retdbdir(),&cfg->root,&virnum);
	if (rc) {
		ERRLOG((LOG_ERR,"clamav: loaddbdir(\"%s\",...) error: %s",
					cfg->dbdir,cl_strerror(rc)));
		return 1;
	}
	rc=cl_build(cfg->root);
	if (rc) {
		ERRLOG((LOG_ERR,"clamav: build error: %s",
					cl_strerror(rc)));
		return 1;
	}

	(*priv)=(void *)cfg;

	ERRLOG((LOG_INFO,"clamav: loaded %d viruses signatures",virnum));
	ERRLOG((LOG_INFO,"clamav: use %s scanning",
					cfg->filescan?"file":"memory"));
	ERRLOG((LOG_INFO,"clamav: %s (%s) OK",VERSION,rcsid));

	return 0;
}

static void
clamav_term(void **priv)
{
	clamav_cfg_t *cfg=*((clamav_cfg_t **)priv);

	if (cfg) {
		cl_free(cfg->root);
		free(cfg);
	}
	*priv=NULL;
}

static int
clamav_scan(char *stage,int depth,slab_t data,varpool_t vp,void *priv)
{
	clamav_cfg_t *cfg=(clamav_cfg_t *)priv;
	int rc=-1;
	const char *virname;
	mattr_t *atr=data.atr;
	char ans[128];

	DPRINT(("clamav_scan enter\n"));

	if (!cfg->scantext &&
	    !((atr) && (slab_size(atr->content_type)) &&
	      (strncasecmp(atr->content_type.beg,"text",
				min(4,slab_size(atr->content_type))) != 0))) {
		DPRINT(("not scanning text type\n"));
		return ZMSCAN_CONTINUE;
	}

	if (cfg->filescan) {
		FILE *tmpf=tmpfile();
		size_t rest=slab_size(data);
		char *p=data.beg;

		DPRINT(("clamav file scan, options=0x%04x\n",cfg->clamopts));
		if (tmpf == NULL) {
			ERRLOG((LOG_ERR,"clamav_scan: open tmp file: %m"));
			goto bailout;
		}
		while (rest) {
			size_t wrote=fwrite(p,1,rest,tmpf);
			rest-=wrote;
			if (ferror(tmpf)) {
				ERRLOG((LOG_ERR,"clamav_scan: fwrite tmp: %m"));
				goto bailout;
			}
		}
		if (fflush(tmpf)) {
			ERRLOG((LOG_ERR,"clamav_scan: fflush tmp: %m"));
			goto bailout;
		}
		rc=cl_scandesc(fileno(tmpf),&virname,NULL,cfg->root,
			&cfg->limits,cfg->clamopts);
		bailout:
		fclose(tmpf);
	} else {
		rc=cl_scanbuff(data.beg,slab_size(data),&virname,cfg->root);
	}
	switch (rc) {
	case 0:
		DPRINT(("clamav scan result clean\n"));
		return ZMSCAN_CONTINUE;
	case 1:
		ERRLOG((LOG_INFO,"clamav: blocked %s",virname));
		snprintf(ans,sizeof(ans),
			"-1 550 5.7.0 Found virus %s in the message",virname);
		vp_set_str(vp,VP_ANSWER_STR,ans);
		return ZMSCAN_STOP;
	default:
		ERRLOG((LOG_ERR,"clamav_scan result rc=%d\n",rc));
		return ZMSCAN_CONTINUE;
	}
}

ZMS_MODULE("content","clamav",clamav_setup,clamav_term,clamav_scan);

