#ifndef LINT
static char *rcsid="$Id: processfile.c 319 2005-05-18 16:11:02Z crosser $";
#endif
                                                                                
/*
	$Log: processfile.c,v $
	Revision 1.20  2004/06/13 10:21:00  crosser
	clean up pthread check
	
	Revision 1.19  2003/09/20 12:02:32  crosser
	one more spam sample
	
	Revision 1.18  2003/09/15 13:32:49  crosser
	make reporting more logical with varpool: just set a variable with
	predefined name and it will go to the SMTP peer!
	
	Revision 1.17  2003/09/14 22:01:13  crosser
	need to initialize hash before readconfig()
	
	Revision 1.16  2003/09/14 21:16:17  crosser
	I hardly beleive it but the new varpool thing seems to work!
	
	Revision 1.15  2003/09/14 11:31:43  crosser
	code cleanup to silence -Wall warnings.  Actually, some of them where bugs.
	Still cannot figure how to initialize `union' without warning
	
	Revision 1.14  2003/09/11 17:15:57  crosser
	make queue file renaming on sigsegv configurable option
	
	Revision 1.13  2003/09/11 15:40:26  crosser
	debugging info on segfault
	
	Revision 1.12  2003/09/11 14:44:27  crosser
	do not try to scan zero size file
	
	Revision 1.11  2003/09/03 19:41:39  crosser
	work in progress on changed calling conventions
	
	Revision 1.10  2003/09/02 22:20:11  crosser
	make initial stage run time configurable
	
	Revision 1.9  2003/09/01 18:20:45  crosser
	proper test format
	debugging readconfig error - int var
	
	Revision 1.8  2003/09/01 16:39:22  crosser
	make DSO actually work
	
	Revision 1.7  2003/09/01 12:16:01  crosser
	make (untested) branch to work without mmap()
	
	Revision 1.6  2003/08/31 21:18:37  crosser
	made plugin framework
	
	Revision 1.5  2003/08/31 13:51:12  crosser
	header autoconfing cleanups
	
	Revision 1.4  2003/08/31 12:58:58  crosser
	make basic separation of lib/ plugins
	configure REPLACE_FUNCS in a right way (hopefully)
	
	Revision 1.3  2003/08/31 11:48:46  crosser
	filling inc and lib
	
	Revision 1.2  2003/08/24 22:12:37  crosser
	some file processing
	
	Revision 1.1  2003/08/24 21:25:33  crosser
	make processfile function
	
*/

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#ifdef HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif
#ifdef HAVE_SYS_MMAN_H
# include <sys/mman.h>
#endif
#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif
#ifdef STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif

#include "rtconfig.h"
#include "report.h"
#include "zmscanner.h"
#include "daemon.h"

#if defined(DEBUG_LINK) && !defined(HAVE_PTHREAD)
extern char q_file[];
#endif

void
processfile(char *fn,varpool_t vp)
{
	int msgfd;
	char *msgdata;
	struct stat stbuf;
	off_t msgsize;
	slab_t data;
	mattr_t attr;
	char rbuf[256];
	static char *nul="nul";
#ifndef HAVE_MMAP
	int len,rest;
	char *ptr;
#endif

	if ((msgfd=open(fn,O_RDONLY)) == -1) {
		snprintf(rbuf,sizeof(rbuf),
				"0 250 Oops: %s: open error %d (%s)",
				fn,errno,strerror(errno));
		vp_set_str(vp,VP_ANSWER_STR,rbuf);
		return;
	}
	if (fstat(msgfd,&stbuf) == -1) {
		snprintf(rbuf,sizeof(rbuf),
				"0 250 Oops: %s: fstat error %d (%s)",
				fn,errno,strerror(errno));
		vp_set_str(vp,VP_ANSWER_STR,rbuf);
		return;
	}
	msgsize=stbuf.st_size;
	if (msgsize == 0) {
		snprintf(rbuf,sizeof(rbuf),
				"0 250 Oops: %s: zero size! no data, no scan",
				fn);
		vp_set_str(vp,VP_ANSWER_STR,rbuf);
		return;
	}
	DPRINT(("real message size %d\n",(int)msgsize));
	if (msgsize > gcfg.maxsize) msgsize=gcfg.maxsize;
	DPRINT(("scanning %d first bytes\n",(int)msgsize));
#ifdef HAVE_MMAP
	if ((msgdata=(char*)mmap((void*)0,msgsize,PROT_READ,
				MAP_SHARED,msgfd,(off_t)0)) == NULL) {
		snprintf(rbuf,sizeof(rbuf),
				"0 250 Oops: %s: mmap error %d (%s)",
				fn,errno,strerror(errno));
		vp_set_str(vp,VP_ANSWER_STR,rbuf);
		return;
	}
#else /* HAVE_MMAP */
	if ((msgdata=malloc(msgsize)) == NULL) {
		snprintf(rbuf,sizeof(rbuf),
				"0 250 Oops: %s: malloc(%d) error %d (%s)",
				fn,msgsize,errno,strerror(errno));
		vp_set_str(vp,VP_ANSWER_STR,rbuf);
		return;
	}
	ptr=msgdata;
	rest=msgsize;
	while (rest) {
		len=read(msgfd,ptr,rest);
		if (len <= 0) break;
		ptr+=len;
		rest-=len;
	}
	if (rest) {
		snprintf(rbuf,sizeof(rbuf),
				"0 250 Oops: %s: read error %d (%s)",
				fn,errno,strerror(errno));
		vp_set_str(vp,VP_ANSWER_STR,rbuf);
		return;
	}
#endif /* HAVE_MMAP */

	initattr(&attr,NULL);
	attr.usefirst=gcfg.firstmimehdr;
	memset(&data,0,sizeof(data));
	data.beg=msgdata;
	data.end=msgdata+msgsize;
	data.atr=(void *)&(attr);
        snprintf(rbuf,sizeof(rbuf),"0 250 Acceptable");

#if defined(DEBUG_LINK) && !defined(HAVE_PTHREAD)
	strlcpy(q_file,fn,256);
#endif

	(void)scandata(gcfg.initstage,0,data,vp);
	data.beg=nul;
	data.end=nul+strlen(nul);
	(void)scandata(gcfg.finalstage,0,data,vp);

#ifdef HAVE_MMAP
	if (munmap(msgdata,msgsize) == -1) {
		snprintf(rbuf,sizeof(rbuf),
				"0 250 Oops: %s: munmap error %d (%s)",
				fn,errno,strerror(errno));
		vp_set_str(vp,VP_ANSWER_STR,rbuf);
		return;
	}
#else
	free(msgdata);
#endif
	if (close(msgfd) == -1) {
		snprintf(rbuf,sizeof(rbuf),
				"0 250 Oops: %s: close error %d (%s)",
				fn,errno,strerror(errno));
		vp_set_str(vp,VP_ANSWER_STR,rbuf);
		return;
	}
	return;
}
