#ifndef LINT
static char *rcsid="$Id: zmscanner.c 297 2005-05-13 17:44:56Z crosser $";
#endif
                                                                                
/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003-2005 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#ifdef STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
# include <stddef.h>
# include <string.h>
#endif
#ifdef HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif
#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif
#include <signal.h>
#include <sys/socket.h>
#include <sys/un.h>
#ifndef OPTARG_DEFINED
#include <getopt.h>
#endif

#include "rtconfig.h"
#include "report.h"
#include "zmscanner.h"
#include "daemon.h"

/* should be in some header file but I cannot find an appropriate one */
void init_plugin_hash(void);
void makepidfile(char *fn);

int verbose=0;
int runchild=0;
int stayalive=1;
int isdaemon=1;

static int killparent=0;
static char csockid[8];

#if defined(DEBUG_LINK) && !defined(HAVE_PTHREAD)
char q_file[256];
char r_file[260];
#endif

#ifdef HAVE_PTHREAD
# define _PTHR "(threaded)"
#else
# define _PTHR "(forking)"
#endif

static void
showver(char *name)
{
	fprintf(stderr,"%s %s Version %s Build %s\n",
					name,_PTHR,VERSION,__DATE__);
}

static void
showhelp(char *name)
{
	fprintf(stderr,"Usage: %s -I configfile -d -V -v -h\n",name);
	fprintf(stderr,"\t-I configfile\t- replacement config [default: %s]\n",DEFAULT_CONFIG);
	fprintf(stderr,"\t-d\t\t- do not go to background\n");
	fprintf(stderr,"\t-V\t\t- print version\n");
	fprintf(stderr,"\t-v\t\t- increase verbosity\n");
	fprintf(stderr,"\t-h\t\t- print this help message\n");
}

RETSIGTYPE
usrhdl(int sig)
{
	DPRINT(("signal %d caught\n",sig));
	switch (sig) {
	case SIGUSR1:	runchild=1; break;
	case SIGUSR2:	stayalive=0; break;
	default:	ERRLOG((LOG_ERR,"unexpected signal %d",sig));
	}
}

void saveqfile(void)
#if defined(DEBUG_LINK) && !defined(HAVE_PTHREAD)
{
	int rc;

	strcpy(r_file,q_file);
	strcat(r_file,".sav");
	rc=link(q_file,r_file);
	ERRLOG((LOG_ERR,"linked %s to %s (rc=%d)",q_file,r_file,rc));
}
RETSIGTYPE
segvhdl(int sig)
{
	(void)signal(SIGSEGV,SIG_DFL);
	ERRLOG((LOG_ERR,"caught sigsegv"));
	saveqfile();
}
#else /* defined(DEBUG_LINK) && !defined(HAVE_PTHREAD) */
{
}
#endif /* defined(DEBUG_LINK) && !defined(HAVE_PTHREAD) */

void
givebirth(int ctlsock,int argc,char *argv[])
{
	pid_t child;

	DPRINT(("givebirth called\n"));

	if ((child=fork()) > 0) {
		DPRINT(("starting new copy as pid %d\n",child));
		return;
	} else if (child < 0) {
		ERRLOG((LOG_ERR,"fork error: %m"))
		return;
	} else {
		int i;
		DPRINT(("child started as pid %d\n",getpid()));
		for (i=3;i<MAXFD;i++) {
			if (i != ctlsock) close(i);
		}
		execv(argv[0],argv);
		DPRINT(("Oops, still here after execv, errno=%d\n",errno));
	}
	return;
}

/* on the forking server let children run on their own */
static void
setcldsig(void)
#ifdef HAVE_PTHREAD
{
	ERRLOG((LOG_DEBUG,"get rid of children: none for thread model"));
}
#else /* HAVE_PTHREAD */
{
# ifdef SA_NOCLDWAIT
	/* FreeBSD hack - setting SIG_IGN is not sufficient to avoid zombies */
	struct sigaction sa;
	ERRLOG((LOG_DEBUG,"get rid of children: BSD way"));
	memset(&sa,0,sizeof(sa));
	sa.sa_sigaction=SIG_IGN;
	sa.sa_flags=SA_NOCLDWAIT;
	sigaction(SIGCHLD,&sa,NULL);
# else
	ERRLOG((LOG_DEBUG,"get rid of children: SysV way"));
	signal(SIGCHLD,SIG_IGN);
# endif
}
#endif /* HAVE_PTHREAD */

int
main(int argc, char *argv[])
{
	int i;
	char *configfile=DEFAULT_CONFIG;
	int ctlsock=-1;
	int rc;
	int tries,on=1;
	int savemask;
	struct sockaddr_un server;
	int nargc=argc;
	char **nargv=argv;

	while ((i=getopt(argc,argv,"I:i:dvVh")) != EOF) switch (i) {
	case 'I':
		/* if someone decides to modify the name displayed in
		   the "ps" output it may be useful to copy the arg... */
		configfile=(char *)malloc(strlen(optarg)+1);
		strcpy(configfile,optarg);
		break;
	case 'i':
		ctlsock=atoi(optarg);
		if (ctlsock > 0) killparent=1;
		break;
	case 'd':
		isdaemon=0;
		break;
	case 'V':
		showver(argv[0]);
		return 0;
	case 'v':
		verbose++;
		break;
	case 'h':
		showhelp(argv[0]);
		return 0;
	default:
		showhelp(argv[0]);
		return 1;
	}

	if (verbose) {
		DPRINT(("starting %d as:",getpid()));
		for (i=0;i<argc;i++) {
			DPRINT((" %s",argv[i]));
		}
		DPRINT(("\n"));
	}

#ifdef HAVE_SYSLOG
	openlog("zmscanner",LOG_CONS|LOG_PID
# ifdef LOG_NDELAY
					|LOG_NDELAY
# endif
						,LOG_MAIL);
#endif

	DPRINT(("process %d starting\n",getpid()));
	ERRLOG((LOG_INFO,"starting %s v.%s build %s %s",
				_PTHR,VERSION,__DATE__,__TIME__));

	init_plugin_hash();

	(void)readconfig(configfile,1);

	if (isdaemon && (ctlsock < 0)) {
		pid_t child;
		if ((child=fork()) > 0) {
			sleep(1);
			return 0;
		} else if (child < 0) {
			perror("fork error");
			return 1;
		} else {
			fflush(stdin);
			fflush(stdout);
			fflush(stderr);
			setbuf(stdin,NULL);
			setbuf(stdout,NULL);
			setbuf(stderr,NULL);
			close(0);
			close(1);
			close(2);
			open("/dev/null",O_RDWR);
			dup(0);
			dup(0);
#ifdef HAVE_SETSID
			setsid();
#else
# ifdef HAVE_SETPGRP
#  ifdef SETPGRP_VOID
			setpgrp();
#  else
			setpgrp(0,0);
#  endif
# endif
#endif
		}
	}

	makepidfile(gcfg.pidfile);

	init_plugins();
	init_dyn_modules();

	if (ctlsock < 0) {
		memset((char *)&server,0,sizeof(server));
		server.sun_family = AF_UNIX;
		strlcpy(server.sun_path,gcfg.socket,sizeof(server.sun_path));
		(void)unlink(server.sun_path);
		if ((ctlsock=socket(AF_UNIX,SOCK_STREAM,0)) < 0) {
			ERRLOG((LOG_ERR,"socket: %m"))
			return 1;
		}
		if (setsockopt(ctlsock,SOL_SOCKET,SO_REUSEADDR,
					(char*)&on,sizeof(on)) < 0) {
			ERRLOG((LOG_ERR,"setsockopt: %m"))
			ctlsock=-1;
			return 1;
		}
		savemask=umask(0);
		for (tries=0;;tries++) {
			if (bind(ctlsock,(struct sockaddr*)&server,
				sizeof(server)-sizeof(server.sun_path)+
					strlen(server.sun_path)+1) < 0) {
				if ((errno == EADDRINUSE) && (tries < 10)) {
					sleep(tries);
					continue;
				}
				ERRLOG((LOG_ERR,"bind: %m"))
				ctlsock=-1;
				return 1;
			} else break;
		}
		(void)umask(savemask);
		if (listen(ctlsock,5) < 0) {
			ERRLOG((LOG_ERR,"listen: %m"));
			return 1;
		}
		sprintf(csockid,"%d",ctlsock);
		nargc+=2;
		nargv=(char**)malloc((nargc+1)*sizeof(char*));
		memcpy(nargv,argv,argc*sizeof(char*));
		nargv[argc]="-i";
		nargv[argc+1]=csockid;
		nargv[argc+2]=NULL;
	}

	setcldsig();

#if defined(DEBUG_LINK) && !defined(HAVE_PTHREAD)
	/* debugging tool */
	(void)signal(SIGSEGV,segvhdl);
#endif
	/* In case the client disconnects before reading our responce */
	(void)signal(SIGPIPE,SIG_IGN);
	/* is this setting kept after raising the signal on SysV?
	   User signal handlers are reset to SIG_DFL.  Let us hope
	   that SIG_IGN is a special setting and is kept forever. */

	(void)signal(SIGUSR1,usrhdl);
	(void)signal(SIGUSR2,usrhdl);

	if (killparent) {
		pid_t parent=getppid();
		if (parent < 0) {
			ERRLOG((LOG_ERR,"getppid returned -1: %m"));
			return 1;
		}
		DPRINT(("killing parent %d\n",parent));
		if (kill(parent,SIGUSR2) < 0) {
			ERRLOG((LOG_ERR,"killing parent %d: %m",parent));
			return 1;
		}
	}

	rc=mainloop(ctlsock,nargc,nargv);

	term_plugins();

	DPRINT(("process %d terminating\n",getpid()));
	ERRLOG((LOG_INFO,"process terminating"));

#ifdef HAVE_SYSLOG
	closelog();
#endif

	return rc;
}
