#ifndef LINT
static char *rcsid="$Id: zmsctl.c 266 2005-04-17 13:37:59Z crosser $";
#endif
                                                                                
/*
	$Log: zmsctl.c,v $
	Revision 1.13  2004/06/13 10:21:00  crosser
	clean up pthread check
	
	Revision 1.12  2004/06/04 16:56:46  crosser
	in README ask to run aclocal -I m4
	bump version
	make man pages distributable
	fix bug in zmsctl
	make FreeBSD compatibility hack in setting SIGCHLD handler
	
	Revision 1.11  2003/09/14 11:31:43  crosser
	code cleanup to silence -Wall warnings.  Actually, some of them where bugs.
	Still cannot figure how to initialize `union' without warning
	
	Revision 1.10  2003/09/11 13:56:26  crosser
	check_ct - watch for empty body.  Test some broken cases
	
	Revision 1.9  2003/09/04 21:23:21  crosser
	use strlcpy;
	check_ct: regex matching works
	
	Revision 1.8  2003/09/03 19:41:39  crosser
	work in progress on changed calling conventions
	
	Revision 1.7  2003/09/03 16:07:43  crosser
	make pid file
	make zmsctl look and work without termios
	make zmsctl use socket name from config
	
	Revision 1.6  2003/09/03 13:17:45  crosser
	getopt arg '-P'
	
	Revision 1.5  2003/09/01 16:39:22  crosser
	make DSO actually work
	
	Revision 1.4  2003/08/31 18:43:23  crosser
	make the thing run in "filter" mode - from stdin to stdout
	
	Revision 1.3  2003/08/31 13:51:12  crosser
	header autoconfing cleanups
	
	Revision 1.2  2003/08/25 10:03:10  crosser
	in threaded version, make master thread wait for subthreads
	make thing compile without termios (but zmsctl won't work in fact)
	
	Revision 1.1  2003/08/24 21:07:17  crosser
	created the whole async infrastructure
	
*/

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif
#ifdef STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif
#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif
#include <termios.h>
#include <sys/socket.h>
#include <sys/un.h>
#ifndef OPTARG_DEFINED
#include <getopt.h>
#endif

#include "report.h"
#include "rtconfig.h"
#include "zmscanner.h"
#include "daemon.h"

int verbose=0;
static char *configfile=DEFAULT_CONFIG;

static void
showver(char *name)
{
#ifdef HAVE_PTHREAD
# define _PTHR "(threaded)"
#else
# define _PTHR "(forking)"
#endif
	fprintf(stderr,"%s %s Version %s Build %s\n",
					name,_PTHR,VERSION,__DATE__);
}

static void
showhelp(char *name)
{
	fprintf(stderr,"Usage: %s -I configfile -V -v -h\n",name);
	fprintf(stderr,"\t-I configfile\t- path to config [default: %s]\n",DEFAULT_CONFIG);
	fprintf(stderr,"\t-V\t\t- print version\n");
	fprintf(stderr,"\t-v\t\t- increase verbosity\n");
	fprintf(stderr,"\t-h\t\t- print this help message\n");
}

static char *crlf="\r\n";
#ifdef HAVE_TERMIOS_H
static char *bsp="\b \b";
#endif

int
main(int argc, char *argv[])
{
	int i,rc;
#ifdef HAVE_TERMIOS_H
	struct termios savetios0,tios0;
#endif
	int msgsock=-1;
	struct sockaddr_un server;
	int running=1,docommand=0;
	int cmdpos=0;
	fd_set ifd,ofd,efd;
	char c;
	char cmd[128];
#ifdef HAVE_TERMIOS_H
	char *p;
	char buf[140];
#endif

	while ((i=getopt(argc,argv,"I:vVh")) != EOF) switch (i) {
	case 'I':
		/* if someone decides to modify the name displayed in
		   the "ps" output it may be useful to copy the arg... */
		configfile=(char *)malloc(strlen(optarg)+1);
		strcpy(configfile,optarg);
		break;
	case 'V':
		showver(argv[0]);
		return 0;
	case 'v':
		verbose++;
		break;
	case 'h':
		showhelp(argv[0]);
		return 0;
	default:
		showhelp(argv[0]);
		return 1;
	}

	readconfig(configfile,0);

	memset((char *)&server,0,sizeof(server));
	server.sun_family = AF_UNIX;
	strlcpy(server.sun_path,gcfg.socket,sizeof(server.sun_path));
	if ((msgsock=socket(AF_UNIX,SOCK_STREAM,0)) < 0) {
		perror("socket");
		return 1;
	}
	if (connect(msgsock,(struct sockaddr *)&server,
		sizeof(server)-sizeof(server.sun_path)+
					strlen(server.sun_path)+1) < 0) {
		perror("connect");
		return 1;
	}

	setbuf(stdout,NULL);
#ifdef HAVE_TERMIOS_H
	if ((tcgetattr(0,&savetios0))) {
		perror("tcgetattr stdio");
		exit(1);
	}
	memcpy(&tios0,&savetios0,sizeof(tios0));
#ifdef HAVE_CFMAKERAW
	cfmakeraw(&tios0);
#else
	tios0.c_iflag=0;
	tios0.c_oflag=0;
	tios0.c_lflag=0;
#endif
	tios0.c_cc[VMIN]=1;
	tios0.c_cc[VTIME]=0;
	tios0.c_cflag|=(CS8|CLOCAL|CREAD);
	tios0.c_cflag&=~(PARENB|PARODD);
	tios0.c_iflag&=~INPCK;
	tios0.c_iflag|=IGNBRK;
	if ((tcsetattr(0,TCSANOW,&tios0))) {
		perror("tcsetattr stdin");
		exit(1);
	}
#endif

	while (running) {
		FD_ZERO(&ifd);
		FD_ZERO(&ofd);
		FD_ZERO(&efd);
		FD_SET(0,&ifd);
		FD_SET(msgsock,&ifd);
		if ((rc=select(msgsock+1,&ifd,&ofd,&efd,NULL)) == -1) {
			perror("select");
			exit(1);
		} else if (rc == 0) {
			printf("timeout, continue\r\n");
		} else {
			if (FD_ISSET(0,&ifd)) {
				if (read(0,&c,1) <= 0) c=-1;
				switch (c) {
#ifdef HAVE_TERMIOS_H
				case '\b':
					cmdpos--;
					puts(bsp);
					break;
				case 3:
				case 4:
				case 27:
#endif
				case -1:
					running=0;
					puts(crlf);
					break;
				case '\n':
				case '\r':
					cmd[cmdpos++]=c;
					cmd[cmdpos]='\0';
					cmdpos=0;
#ifdef HAVE_TERMIOS_H
					puts(crlf);
#endif
					docommand=1;
					break;
				default:
					if (cmdpos < (sizeof(cmd)-1)) {
						cmd[cmdpos++]=c;
#ifdef HAVE_TERMIOS_H
						putchar(c);
					} else {
						putchar(7);
#endif
					}
					break;
				}
			} else if (FD_ISSET(msgsock,&ifd)) {
				if ((rc=read(msgsock,&c,1)) == 1) {
					putchar(c);
				} else if (rc == 0) {
					printf("remote gone\r\n");
					running=0;
				} else printf("read returned %d\r\n",rc);
			} else {
				printf("panic! Why did select exit?!\r\n");
			}
		}
		if (docommand) {
			docommand=0;
			write(msgsock,cmd,strlen(cmd));
		}
	}
	printf("shutting down\r\n");

#ifdef HAVE_TERMIOS_H
	if ((tcsetattr(0,TCSANOW,&savetios0))) {
		perror("tcsetattr restore stdin");
	}
#endif
	close(msgsock);
	return 0;
}
