#ifndef LINT
static char *rcsid="$Id: rtconfig.c 301 2005-05-14 11:51:57Z crosser $";
#endif
                                                                                
/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003-2005 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#ifdef STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
#endif
#ifdef HAVE_DLFCN_H
# include <dlfcn.h>
#endif
#ifdef HAVE_LINK_H
# include <link.h>
#endif

#include "report.h"
#include "rtconfig.h"

#define MAXMSGSIZE 8196
#define DEFAULT_SOCKPATH "/tmp/zmscanner"
#define DEFAULT_INITSTAGE "zmsg";
#define DEFAULT_FINALSTAGE "zfin";

int
verb_module(char *verb,char *data,char *fn,int count);

static int doload;
static char *moddir=DEFAULT_MODDIR;

typedef struct _module_initer {
	struct _module_initer *next;
	void (*init_func)(void);
} module_initer_t;

static module_initer_t *head_initer=NULL;
static module_initer_t **cur_initer=(module_initer_t**)(&head_initer);

static struct _verbs {
	char *verb;
	enum {badverb,Boolean,integer,string,exec} vtype;
	union _w {
			int *i;
			char **s;
			int (*e)(char *v,char *p,char *fn,int c);
		} where;
} verbs[] = {
	{"firstmimehdr",Boolean,	{&gcfg.firstmimehdr}},
	{"maxsize",	integer,	{&gcfg.maxsize}},
	{"socket",	string,		{&gcfg.socket}},
	{"initstage",	string,		{&gcfg.initstage}},
	{"finalstage",	string,		{&gcfg.finalstage}},
	{"pidfile",	string,		{&gcfg.pidfile}},
	{"modconfdir",	string,		{&gcfg.modconfdir}},
	{"miltersock",	string,		{&gcfg.miltersock}},
	{"moddir",	string,		{&moddir}},
	{"module",	exec,		{verb_module}},
	{NULL,		badverb,	{NULL}}
};

int
readconfig(char *fn,int loadmodules)
{
	FILE *fp;
	char buf[256];
	int count=0;

	doload=loadmodules;

	gcfg.socket=DEFAULT_SOCKPATH;
	gcfg.initstage=DEFAULT_INITSTAGE;
	gcfg.finalstage=DEFAULT_FINALSTAGE;
	gcfg.pidfile=NULL;
	gcfg.maxsize=MAXMSGSIZE;

	DPRINT(("readconfig fn=%s\n",fn));
	if ((fp=fopen(fn,"r")) == NULL) {
		perror(fn);
		return -1;
	}
	while (fgets(buf,sizeof(buf)-1,fp)) {
		char *p,*q;
		int i,factor;

		count++;
#if 0
		DPRINT(("readconfig line %d: \"%s\"\n",count,buf));
#endif
		if (buf[0] == '#') continue;
		buf[sizeof(buf)-1]='\0';
		p=buf+strlen(buf)-1;
		while ((p >= buf) && ((*p == '\r') || (*p == '\n') ||
				     (*p == ' ') || (*p == '\t'))) *p--='\0';
		if (buf[0] == '\0') continue;
		for (p=buf;(*p != ' ') && (*p != '\t') && (*p != '\0');p++) ;
		*p++='\0';
		while ((*p == ' ') || (*p == '\t')) p++;
		for (i=0;verbs[i].verb;i++) {
			if (strcmp(verbs[i].verb,buf) == 0) break;
		}
		switch (verbs[i].vtype) {
		case Boolean:
			if ((strcmp(p,"yes") == 0) ||
			    (strcmp(p,"on") == 0) ||
			    (strcmp(p,"true") == 0))
				*verbs[i].where.i=1;
			else if ((strcmp(p,"no") == 0) ||
				 (strcmp(p,"off") == 0) ||
				 (strcmp(p,"false") == 0))
				*verbs[i].where.i=0;
			else
				ERRLOG((LOG_ERR,"%s(%d): bad Boolean \"%s\"",
					fn,count,p));
			break;
		case integer:
			q=p+strlen(p)-1;
			switch (*q) {
			case 'k':
			case 'K':
				factor=1024;
				*q='\0';
				break;
			case 'm':
			case 'M':
				factor=1024*1024;
				*q='\0';
				break;
			default:
				factor=1;
				break;
			}
			*verbs[i].where.i=atoi(p)*factor;
			break;
		case string:
			*verbs[i].where.s=(char*)malloc(strlen(p)+1);
			strcpy(*verbs[i].where.s,p);
			break;
		case exec:
			(void)(*verbs[i].where.e)(buf,p,fn,count);
			break;
		case badverb:
			ERRLOG((LOG_ERR,"%s(%d): bad verb \"%s\"",
					fn,count,buf));
			break;
		}
	}
	fclose(fp);
	DPRINT(("moddir=%s sock=%s maxsize=%d\n",
				moddir,gcfg.socket,gcfg.maxsize));
	return 0;
}

void
init_dyn_modules(void)
{
#ifdef HAVE_DLOPEN
	module_initer_t *cur_initer;

	for (cur_initer=head_initer;cur_initer;cur_initer=cur_initer->next) {
		(*(cur_initer->init_func))();
	}
#else
	return;
#endif
}

int
verb_module(char *verb,char *data,char *fn,int count)
{
#ifdef HAVE_DLOPEN
	void *dso;
	char *dlerr;
	char buf[256];
	void (*mod_init_func)(void);

	if (!doload) return 0;

	DPRINT(("loading module \"%s\"\n",data));
	snprintf(buf,sizeof(buf)-1,"%s/%s",moddir,data);
	dso=dlopen(buf,RTLD_NOW);
	if ((dlerr=dlerror()) != NULL)  {
		ERRLOG((LOG_ERR,"%s(%d): %s",fn,count,dlerr));
		return 1;
	}
	mod_init_func=dlsym(dso,"zms_mod_init");
	if ((dlerr=dlerror()) != NULL)  {
		ERRLOG((LOG_ERR,"%s(%d): %s",fn,count,dlerr));
		return 1;
	}
	ERRLOG((LOG_INFO,"adding module %s",buf));
#if 1
	(*cur_initer)=(module_initer_t*)malloc(sizeof(module_initer_t));
	(*cur_initer)->next=NULL;
	(*cur_initer)->init_func=mod_init_func;
	cur_initer=&((*cur_initer)->next);
#else
	(*mod_init_func)();
#endif
	return 0;
#else /* HAVE_DLOPEN */
	ERRLOG((LOG_ERR,"%s(%d): %s not supported without dlopen()",
			fn,count,verb));
	return 1;
#endif /* HAVE_DLOPEN */
}
