#ifndef LINT
static char *rcsid="$Id: runplugin.c 266 2005-04-17 13:37:59Z crosser $";
#endif

/*
	$Log: runplugin.c,v $
	Revision 1.13  2003/09/14 21:16:17  crosser
	I hardly beleive it but the new varpool thing seems to work!
	
	Revision 1.12  2003/09/14 20:09:25  crosser
	varpool implementation, iteration 0
	
	Revision 1.11  2003/09/14 18:19:52  crosser
	use lhash to search stages
	
	Revision 1.10  2003/09/14 14:00:06  crosser
	begin introduction of lhash...
	
	Revision 1.9  2003/09/14 11:31:44  crosser
	code cleanup to silence -Wall warnings.  Actually, some of them where bugs.
	Still cannot figure how to initialize `union' without warning
	
	Revision 1.8  2003/09/03 19:41:39  crosser
	work in progress on changed calling conventions
	
	Revision 1.7  2003/09/01 22:39:00  crosser
	scan interesting headers
	FIXME: skip processing of last header
	
	Revision 1.6  2003/09/01 09:39:21  crosser
	add head comments where necessary
	add run time config function
	
	Revision 1.5  2003/09/01 08:42:01  crosser
	make termination func work
	
	Revision 1.4  2003/09/01 06:03:31  crosser
	implement code for "naeve" filter (but working yet)
	
	Revision 1.3  2003/08/31 21:18:37  crosser
	made plugin framework
	
	Revision 1.2  2003/08/31 12:58:58  crosser
	make basic separation of lib/ plugins
	configure REPLACE_FUNCS in a right way (hopefully)
	
	Revision 1.1  2003/08/31 11:48:46  crosser
	filling inc and lib
	
*/

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include "config.h"
#ifdef STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
#endif
#ifdef HAVE_STDDEF_H
# include <stddef.h>
#endif

#include "lhash.h"
#include "report.h"
#include "zmscanner.h"
#include "plugin.h"

LHASH *stagehash=(LHASH *)0;

static unsigned long
stagehash_hash(struct _stage *stage) {
	return lh_strhash(stage->name);
}

static int
stagehash_cmp(struct _stage *stage1,struct _stage *stage2)
{
	return strcmp(stage1->name,stage2->name);
}

static void
stagehash_destroy(struct _stage *stage,LHASH *lh)
{
	struct _stage *del;
	struct _plugin *pp,*npp;

	del=(struct _stage *)lh_delete(lh,stage);
	if (del) {
		for (pp=del->plugin;pp;pp=npp) {
			npp=pp->next;
			DPRINT(("terminating stage=%s name=%s\n",
							del->name,pp->name));
			(pp->term_func)(&(pp->priv));
			free(pp);
		}
		free(del);
	}
}

static IMPLEMENT_LHASH_HASH_FN(stagehash_hash,struct _stage *);
static IMPLEMENT_LHASH_COMP_FN(stagehash_cmp,struct _stage *);
static IMPLEMENT_LHASH_DOALL_ARG_FN(stagehash_destroy,struct _stage *,LHASH *);

void
init_plugin_hash(void)
{
	stagehash=lh_new(LHASH_HASH_FN(stagehash_hash),
			LHASH_COMP_FN(stagehash_cmp));
}

int
register_plugin(char *stage,char *name,
		int (*init_func)(void **priv),
		void (*term_func)(void **priv),
		int (*scan_func)(char *stage,int depth,
				slab_t data,varpool_t vp,void *priv))
{
	void *priv;
	int rc;
	struct _stage fstage;
	struct _stage *tmp;
	struct _stage *sp;
	struct _plugin **pp;

	DPRINT(("register_plugin stage=%s name=%s\n",stage,name));
	if (strlen(stage) > (MAXNAME-1)) {
		ERRLOG((LOG_ERR,"plugin stage=%s name==%s stage too long",stage,name));
		return -1;
	}
	if (strlen(stage) > (MAXNAME-1)) {
		ERRLOG((LOG_ERR,"plugin stage=%s name==%s name too long",stage,name));
		return -1;
	}
	if ((rc=(*init_func)(&priv)) != 0) {
		DPRINT(("plugin stage=%s name=%s init fail\n",stage,name));
		ERRLOG((LOG_ERR,"plugin stage=%s name=%s init fail",stage,name));
		return rc;
	}
	DPRINT(("plugin stage=%s name=%s init complete\n",stage,name));

	strcpy(fstage.name,stage);
	sp=lh_retrieve(stagehash,(void *)&fstage);
	if (sp == NULL) {
		sp=(struct _stage *)malloc(sizeof(struct _stage));
		sp->plugin=NULL;
		strcpy(sp->name,stage);
		tmp=(struct _stage *)lh_insert(stagehash,(void*)sp);
		if (tmp) {
			ERRLOG((LOG_ERR,"cannot be: hash exists for %s",stage));
			abort();
		}
	}
	for (pp=&(sp->plugin);*pp;pp=&((*pp)->next)) {
		if (strcmp(name,(*pp)->name) == 0) break;
	}
	if (*pp == NULL) {
		(*pp)=(struct _plugin *)malloc(sizeof(struct _plugin));
		(*pp)->next=NULL;
		(*pp)->init_func=init_func;
		(*pp)->term_func=term_func;
		(*pp)->scan_func=scan_func;
		(*pp)->priv=priv;
		strcpy((*pp)->name,name);
	} else {
		ERRLOG((LOG_ERR,"plugin stage=%s name=%s already exist",stage,name));
		return rc;
	}
	return 0;
}

void
term_plugins(void)
{
	DPRINT(("term_plugins entered\n"));
	stagehash->down_load=0; /* "second best solution" */
	lh_doall_arg(stagehash,LHASH_DOALL_ARG_FN(stagehash_destroy),
							(void *)stagehash);
	lh_free(stagehash);
	stagehash=NULL;
}
