#ifndef LINT
static char *rcsid="$Id: breakhdr_cte.c 279 2005-05-10 14:44:39Z crosser $";
#endif

/*
	$Log: breakhdr_cte.c,v $
	Revision 1.2  2003/09/13 11:41:16  crosser
	make new header parsing actually work
	
	Revision 1.1  2003/09/12 15:22:41  crosser
	break parsing to separate modules (just placeholders for now)
	
	Revision 1.1  2003/09/12 14:18:34  crosser
	placeholders for header processors
	
*/
                                                                                
/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#ifdef STDC_HEADERS
# include <stdio.h>
# include <string.h>
# include <ctype.h>
#endif

#include "report.h"
#include "zmscanner.h"

static int
breakhdr_cte_setup(void **cfgp)
{
	DPRINT(("breakhdr_cte_setup called\n"));
	(*cfgp)=NULL;
	return 0;
}

static void
breakhdr_cte_term(void **cfgp)
{
	DPRINT(("breakhdr_cte_term called\n"));
}

static struct _encs {
	char *str;
	benc_t idx;
} encs[] = {
	{"quoted-printable",	e_qp},
	{"base64",		e_base64},
	{"x-uuencode",		e_uue},
	{NULL,			e_plain}
};
#define NPATS (sizeof(encs)/sizeof(struct _encs))

static int
breakhdr_cte_scan(char *stage,int depth,slab_t data,varpool_t vp,void *priv)
{
	int rc,i,miss;
	mattr_t *matr=(mattr_t *)data.atr;
	benc_t e;
	char *p,*q[NPATS];

	DPRINT(("breakhdr_cte_scan called size=%d\n",slab_size(data)));

	if (matr->usefirst && matr->enc_set) {
		DPRINT(("breakhdr_cte_scan not first, ignore\n"));
		return ZMSCAN_CONTINUE;
	}
	matr->enc_set=1;

	for (i=0;encs[i].str;i++) q[i]=encs[i].str;
	for (p=data.beg;p<data.end;p++) {
		miss=1;
		for (i=0;encs[i].str;i++) {
			if (*(q[i]) == '\0') goto found;
			if (toupper(*q[i]) == toupper(*p)) {
				q[i]++;
				miss=0;
			} else q[i]=encs[i].str;
		}
		if (miss) goto found;
	}
	found:
	e=encs[i].idx;
	matr->benc=e;

	return ZMSCAN_CONTINUE;
}

ZMS_MODULE("rfc822hdr_cte","breakhdr_cte",breakhdr_cte_setup,
				breakhdr_cte_term,breakhdr_cte_scan);
