#ifndef LINT
static char *rcsid="$Id: check_ct.c 266 2005-04-17 13:37:59Z crosser $";
#endif

/*
	$Log: check_ct.c,v $
	Revision 1.13  2003/09/18 21:29:55  crosser
	bugfix: clear whitespace to the beg of config line
	
	Revision 1.12  2003/09/18 21:21:26  crosser
	bugfix: enclose ||'s in brackets properly
	
	Revision 1.11  2003/09/15 13:32:49  crosser
	make reporting more logical with varpool: just set a variable with
	predefined name and it will go to the SMTP peer!
	
	Revision 1.10  2003/09/14 22:01:13  crosser
	need to initialize hash before readconfig()
	
	Revision 1.9  2003/09/14 21:16:18  crosser
	I hardly beleive it but the new varpool thing seems to work!
	
	Revision 1.8  2003/09/13 18:35:03  crosser
	report config errors to syslog (because if we are respawning there
	is not stderr).  Compile-time warnings.
	
	Revision 1.7  2003/09/13 11:41:16  crosser
	make new header parsing actually work
	
	Revision 1.6  2003/09/11 16:34:54  crosser
	examination shows that strlcpy is not suitable when source data is
	of unlimited site.  It segfaults.  Shit.  Fallback to old good strncpy.
	
	Revision 1.5  2003/09/11 13:56:26  crosser
	check_ct - watch for empty body.  Test some broken cases
	
	Revision 1.4  2003/09/11 08:24:06  crosser
	cosmetic
	
	Revision 1.3  2003/09/08 12:55:55  crosser
	make static and dynamic plugins syntactically identical
	
	Revision 1.2  2003/09/05 15:25:11  crosser
	ceck_ct plugin finally works.
	
	Revision 1.1  2003/09/04 21:23:21  crosser
	use strlcpy;
	check_ct: regex matching works
	
*/
                                                                                
/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#ifdef HAVE_REGCOMP

#include <sys/types.h>
#ifdef HAVE_REGEX_H
# include <regex.h>
#endif
#ifdef STDC_HEADERS
# include <stdio.h>
# include <string.h>
# include <ctype.h>
#endif

#include "report.h"
#include "zmscanner.h"

#define CONFFILE "check_ct.conf"

#define min(x,y) ((x<y)?x:y)

static struct _verbs {
	char *verb;
} verbs[] = {
	{"name"},
	{"re"},
	{NULL}
};
#define NVERBS (sizeof(verbs)/sizeof(struct _verbs)-1)

struct _cfg {
	struct _cfg *next;
	int vi;
	char *comm;
	regex_t preg;
};

static int
check_ct_setup(void **priv)
{
	struct _cfg **cfgp=(struct _cfg **)priv;
	int rc,count=0;
	char buf[256];
	char fbuf[128];
	FILE *fp;
	struct _verb *verb;
	int vi;
	int cflags;
	char *eob,*p,*q,*re,*comm;
	char sep;
	regex_t preg;

	DPRINT(("check_ct_setup called\n"));

	snprintf(fbuf,sizeof(fbuf),"%s/%s",modconfdir(),CONFFILE);
	if ((fp=fopen(fbuf,"r")) == NULL) {
		ERRLOG((LOG_ERR,"check_ct: cannot open config \"%s\": %m",
				fbuf));
		return 1;
	}
	while (fgets(buf,sizeof(buf),fp)) {
		count++;
		cflags=REG_EXTENDED|REG_NOSUB;
		buf[sizeof(buf)-1]='\0';
		p=buf+strlen(buf)-1;
		if ((*p != '\r') && (*p != '\n')) {
			ERRLOG((LOG_ERR,"check_ct: %s(%d): too long (max %d)",
						fbuf,count,sizeof(buf)-1));
			return 1;
		}
		while ((p >= buf) && ((*p == '\r') || (*p == '\n'))) *p--='\0';
		if (buf[0] == '\0') continue;
		if (buf[0] == '#') continue;
		eob=p+1;
		for (p=buf;(*p != ' ') && ((*p != '\t') && (*p != '\0'));p++) ;
		*p++='\0';
		while ((p < eob) && ((*p == ' ') || (*p == '\t'))) p++;
		sep=*p++;
		re=p;
		if (re >= eob) {
			ERRLOG((LOG_ERR,"check_ct: %s(%d): no regex",
								fbuf,count));
			return 1;
		}
		while ((p < eob) && (*p != sep)) p++;
		*p++='\0';
		while ((p < eob) && (*p != ' ') && (*p != '\t')) {
			DPRINT(("flag: %c\n",*p));
			switch (*p) {
			case 'i':
				cflags |= REG_ICASE;
				break;
			}
			p++;
		}
		while ((p < eob) && ((*p == ' ') || (*p == '\t'))) p++;

		if (*p) {
			comm=(char *)malloc(strlen(p)+1);
			strcpy(comm,p);
		} else {
			comm=(char *)malloc(strlen("Bad pattern match")+1);
			strcpy(comm,"Bad pattern match");
		}

		for (vi=0;verbs[vi].verb;vi++) {
			if (strcmp(buf,verbs[vi].verb) == 0) break;
		}
		if (vi > NVERBS) {
			ERRLOG((LOG_ERR,"check_ct: %s(%d): bad verb \"%s\"",
							fbuf,count,buf));
			return 1;
		}
		switch (vi) {
		case 0: /* name */
			cflags |= REG_NEWLINE;
			break;
		}

		rc=regcomp(&preg,re,cflags);
		if (rc) {
			regerror(rc,&preg,fbuf,sizeof(buf));
			ERRLOG((LOG_ERR,"check_ct: %s(%d) Error in re \"%s\"",
							fbuf,count,re));
			return 1;
		}
		DPRINT(("verb: %s(%d) re: \"%s\" comm: \"%s\"\n",
							buf,vi,re,comm));
		(*cfgp)=(struct _cfg *)malloc(sizeof(struct _cfg));
		(*cfgp)->next=NULL;
		(*cfgp)->vi=vi;
		memcpy(&((*cfgp)->preg),&preg,sizeof(preg));
		(*cfgp)->comm=comm;

		cfgp=&((*cfgp)->next);
	}
	ERRLOG((LOG_INFO,"check_ct: %s (%s) OK",VERSION,rcsid));
	return 0;
}

static void
check_ct_term(void **priv)
{
	struct _cfg *cfgp=*(struct _cfg **)priv;
	struct _cfg *cur;

	DPRINT(("check_ct_term called\n"));
	for (cur=cfgp;cur;cur=cfgp) {
		cfgp=cur->next;
		DPRINT(("freeing %d: %s\n",cur->vi,cur->comm));
		free(cur->comm);
		regfree(&cur->preg);
		free(cur);
	}
	*priv=NULL;
}

static int
check_ct_scan(char *stage,int depth,slab_t data,varpool_t vp,void *priv)
{
	struct _cfg *cfgp;
	mattr_t *atr=(mattr_t *)data.atr;
	int rc;
	char ans[256],buf[256],ebuf[256];

	DPRINT(("check_ct_scan called on \"%.*s\" (%d)\n",
		slab_size(data),data.beg,slab_size(data)));

	if (atr == NULL) {
		ERRLOG((LOG_ERR,"check_ct_scan called but atr not supplied"));
		return ZMSCAN_CONTINUE;
	}
	DPRINT(("name is \"%.*s\" (%d)\n",
		slab_size(atr->name),atr->name.beg,slab_size(atr->name)));

	for (cfgp=(struct _cfg *)priv;cfgp;cfgp=cfgp->next) {
		DPRINT(("check against: %d: %s\n",cfgp->vi,cfgp->comm));
		switch (cfgp->vi) {
		case 0: /* name */
			if (slab_size(atr->name) == 0) continue;
			strncpy(buf,atr->name.beg,
				min(slab_size(atr->name),sizeof(buf)-1));
			buf[min(slab_size(atr->name),sizeof(buf)-1)]='\0';
			break;
		case 1: /* re */
			if (slab_size(data) == 0) continue;
			strncpy(buf,data.beg,
				min(slab_size(data),sizeof(buf)-1));
			buf[min(slab_size(data),sizeof(buf)-1)]='\0';
			break;
		}
		DPRINT(("matching in buffer: \"%s\" against %p (%s)\n",
					buf,&cfgp->preg,cfgp->comm));
		rc=regexec(&cfgp->preg,buf,0,NULL,0);
		switch (rc) {
		case 0:
			snprintf(ans,sizeof(ans),"-1 550 %s",cfgp->comm);
			DPRINT(("put answer \"%s\" in varpool at %p\n",ans,vp));
			vp_set_str(vp,VP_ANSWER_STR,ans);
			return ZMSCAN_STOP;
		case REG_NOMATCH:
			DPRINT(("Name \"%s\" does not match label \"%s\"\n",
					buf,cfgp->comm));
			break;
		default:
			regerror(rc,&cfgp->preg,ebuf,sizeof(ebuf));
			ERRLOG((LOG_ERR,"check_ct: Error in re labelled %s: %s",
							cfgp->comm,ebuf));
			break;
		}
	}
	return ZMSCAN_CONTINUE;
}
                                                                                
ZMS_MODULE("rfc822hdr_ct","check_ct",check_ct_setup,
				check_ct_term,check_ct_scan);

#else /* HAVE_REGCOMP */

void
check_ct(void){}

#endif /* HAVE_REGCOMP */
