#ifndef LINT
static char *rcsid="$Id: decode_qp.c 266 2005-04-17 13:37:59Z crosser $";
#endif

/*
	$Log: decode_qp.c,v $
	Revision 1.5  2003/09/11 09:03:00  crosser
	cosmetics
	
	Revision 1.4  2003/09/09 20:02:10  crosser
	complete dispatcher; change "body" stage to "content" for consistency
	
	Revision 1.3  2003/09/08 12:55:55  crosser
	make static and dynamic plugins syntactically identical
	
	Revision 1.2  2003/09/06 20:27:45  crosser
	nicely allow broken end-of-message boundary
	
	Revision 1.1  2003/09/05 17:43:27  crosser
	placeholders for body decoders
	
*/
                                                                                
/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#ifdef STDC_HEADERS
# include <stdio.h>
# include <string.h>
#endif

#include "report.h"
#include "zmscanner.h"

#define min(x,y) ((x<y)?(x):(y))

static int
decode_qp_setup(void **cfgp)
{
	DPRINT(("decode_qp_setup called\n"));
	(*cfgp)=NULL;
	return 0;
}

static void
decode_qp_term(void **cfgp)
{
	DPRINT(("decode_qp_term called\n"));
}

static int
decode_qp_scan(char *stage,int depth,slab_t data,varpool_t vp,void *priv)
{
	int rc;
	slab_t edata;
	char *dec_data;
	char *p,*q;
	char q1,q2;
	enum {qpass,qwait1,qwait2} qstatus;

	DPRINT(("decode_qp_scan called size=%d\n",slab_size(data)));

	dec_data=(char *)malloc(slab_size(data));
	if (dec_data == NULL) {
		ERRLOG((LOG_ERR,"decode_qp could not alloc %d bytes",
							slab_size(data)));
		return ZMSCAN_CONTINUE;
	}

	q=dec_data;
	qstatus=qpass;
	for (p=data.beg;p<data.end;p++) switch (qstatus) {
	case qpass:
		if (*p == '=') qstatus=qwait1;
		else *q++=*p;
		break;
	case qwait1:
		if ((*p == '=') || (*p == '\n') || (*p == '\r')) {
			*q++=*p;
			qstatus=qpass;
		} else if ((*p >= '0') && (*p <= '9')) {
			q1=(*p)-'0';
			qstatus=qwait2;
		} else if ((*p >= 'a') && (*p <= 'f')) {
			q1=(*p)-'a'+10;
			qstatus=qwait2;
		} else if ((*p >= 'A') && (*p <= 'F')) {
			q1=(*p)-'A'+10;
			qstatus=qwait2;
		} else {
			*q++='=';
			*q++=*p;
			qstatus=qpass;
		}
		break;
	case qwait2:
		if ((*p >= '0') && (*p <= '9')) {
			q2=(*p)-'0';
			*q++=(q1<<4)|q2;
			qstatus=qpass;
		} else if ((*p >= 'a') && (*p <= 'f')) {
			q2=(*p++)-'a'+10;
			*q++=(q1<<4)|q2;
			qstatus=qpass;
		} else if ((*p >= 'A') && (*p <= 'F')) {
			q2=(*p)-'A'+10;
			*q++=(q1<<4)|q2;
			qstatus=qpass;
		} else {
			*q++='=';
			*q++=*(p-1);
			*q++=*p;
			qstatus=qpass;
		}
		break;
	}

	edata.beg=dec_data;
	edata.end=q;
	edata.atr=data.atr;

	DPRINT(("decode_qp_scan decoded size=%d\n",slab_size(edata)));
	DPRINT(("data: \"%.*s\"\n",min(40,slab_size(edata)),edata.beg));

	rc=scandata("content",depth,edata,vp);
	free(dec_data);
	return rc;
}

ZMS_MODULE("body_qp","decode_qp",decode_qp_setup,decode_qp_term,decode_qp_scan);
